/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util.h"

/* declare detection functions */
int rule15327eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:to_client; */
static FlowFlags rule15327flow0 = 
{
    FLOW_TO_CLIENT
};

static RuleOption rule15327option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule15327flow0
    }
};
/* byte_test:size 2, value 7999, operator >, offset 2; */
static ByteData rule15327byte_test1 = 
{
    2, /* size */
    CHECK_AND, /* operator */
    32768, /* value */
    2, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE /* flags */
};

static RuleOption rule15327option1 = 
{
    OPTION_TYPE_BYTE_TEST,
    {
        &rule15327byte_test1
    }
};

/* references for sid 15327 */
/* reference: bugtraq "31881"; */
static RuleReference rule15327ref1 = 
{
    "bugtraq", /* type */
    "31881" /* value */
};

/* reference: cve "2008-2469"; */
static RuleReference rule15327ref2 = 
{
    "cve", /* type */
    "2008-2469" /* value */
};

static RuleReference *rule15327refs[] =
{
    &rule15327ref1,
    &rule15327ref2,
    NULL
};

/* metadata for sid 15327 */
/* metadata:service dns, policy balanced-ips drop, policy security-ips drop; */
static RuleMetaData rule15327service1 = 
{
    "service dns"
};
//
//
//static RuleMetaData rule15327policy1 = 
//{
//    "policy balanced-ips drop"
//};
//
//static RuleMetaData rule15327policy2 = 
//{
//    "policy security-ips drop"
//};

static RuleMetaData rule15327policy3 = 
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule15327metadata[] =
{
    &rule15327service1,
//    &rule15327policy1,
//    &rule15327policy2,
    &rule15327policy3,
    NULL
};

RuleOption *rule15327options[] =
{
    &rule15327option0,
    &rule15327option1,
    NULL
};

Rule rule15327 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_UDP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "53", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       15327, /* sigid */
       8, /* revision */
   
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "PROTOCOL-DNS libspf2 DNS TXT record parsing buffer overflow attempt",     /* message */
       rule15327refs /* ptr to references */
       ,rule15327metadata
   },
   rule15327options, /* ptr to rule options */
   &rule15327eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule15327eval(void *p) {
    
   const uint8_t *cursor_normal = 0;
   const uint8_t *end_of_payload;

   uint16_t numanswers;
   uint16_t numqueries;
	
   uint16_t len;
   uint32_t total = 0;

   int i;

   SFSnortPacket *sp = (SFSnortPacket *) p;

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;
    
   // flow:to_client;
   if (checkFlow(p, rule15327options[0]->option_u.flowFlags) > 0 ) {
      // byte_test:size 2, value 7999, operator >, offset 2;
      if (byteTest(p, rule15327options[1]->option_u.byte, cursor_normal) > 0) {
         
         if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
            return RULE_NOMATCH;  
			
         if ((cursor_normal+12) > end_of_payload)
            return RULE_NOMATCH;

         // Extract number of query and answer records
         numqueries = read_big_16(cursor_normal+4);
         numanswers = read_big_16(cursor_normal+6);
 
         cursor_normal += 12;			

         // Iterate through variable-sized query records to skip to the answer records.
         for(i = 0; i < numqueries; i++)
         {
            while(cursor_normal < end_of_payload && *cursor_normal != 0 && !((*cursor_normal & 0xc0) == 0xc0)) {
               cursor_normal += *cursor_normal + 1;
            }

            if (cursor_normal >= end_of_payload)
               return RULE_NOMATCH;

            cursor_normal += ((*cursor_normal & 0xc0) == 0xc0) ? 2 : 1 ;
            cursor_normal += 2+2;
         }

         if(cursor_normal >= end_of_payload)
            return RULE_NOMATCH;

         // Iterate through answer records
         for(i = 0; i < numanswers; i++)
         {
            // Reset the counter used to detect the overflow for each new answer record
            total = 0; 
            while(cursor_normal < end_of_payload && *cursor_normal != 0 && !((*cursor_normal & 0xc0) == 0xc0)) {
               cursor_normal += *cursor_normal + 1;
            }

            if(cursor_normal >= end_of_payload)
               return RULE_NOMATCH;

            cursor_normal += ((*cursor_normal & 0xc0) == 0xc0) ? 2 : 1 ;

			if ((cursor_normal + 1) >= end_of_payload)
			   return RULE_NOMATCH;

            // Check that the record type is TXT, that is, 0x10
            if (*(cursor_normal + 1) != 0x10)
               return RULE_NOMATCH;

            cursor_normal += 2+2+4;

            if (cursor_normal + 1 >= end_of_payload)
               return RULE_NOMATCH;

            // Extract the length field
            len = read_big_16_inc(cursor_normal);

            // Iterate through the byte[data] section and add each of the 
            // individual string lengths together
            while(cursor_normal < end_of_payload && total < len) {
               total += *cursor_normal + 1;
               cursor_normal += *cursor_normal + 1;
            }

            // Alert if the sum (total) of the inidividual string lengths
            // exceeds the length field for the entire data section
            if(cursor_normal >= end_of_payload)
               return RULE_NOMATCH;
            else if(total > len)
               return RULE_MATCH;
         }
      }
   }

   return RULE_NOMATCH;

}

/*
Rule *rules[] = {
    &rule15327,
    NULL
};
*/
